-- Aesthetics
-- Author: Machiavelli
-- DateCreated: 7/23/2012 11:30:07 AM
--------------------------------------------------------------
function CultureBoostOnCityStateCapture(hexPos, playerID, cityID, newPlayerID)
	local player = Players[newPlayerID];
	local plot = Map.GetPlot(ToGridFromHex(hexPos.x, hexPos.y));
	local city = plot:GetPlotCity();
	local policyID = GameInfoTypes["POLICY_AESTHETICS"];

	-- Only run this if the player has the aesthetics policy and the city is a city-state
	if (player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID) and Players[city:GetOriginalOwner()]:IsMinorCiv()) then
		local bonusCulture = 250;
		-- Adjust the size of the bonus based on the game speed
		local speedCulturePercent = GameInfo.GameSpeeds[Game:GetGameSpeedType()].CulturePercent;
		local adjustedBonusCulture = (bonusCulture * speedCulturePercent) / 100;
		-- Give the culture
		player:SetJONSCulture(player:GetJONSCulture() + adjustedBonusCulture);

		-- Send a notification to the player
		local text = Locale.ConvertTextKey("TXT_KEY_REWARD_FROM_CITY_STATE_CAPTURE", tostring(adjustedBonusCulture), city:GetName());
		player:AddNotification(NotificationTypes.NOTIFICATION_GENERIC, text, text);
	end
end
Events.SerialEventCityCaptured.Add(CultureBoostOnCityStateCapture);